<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * CompanyReport
 *
 * @ORM\Table(name="company_reports")
 * @ORM\Entity
 *
 * @ORM\HasLifecycleCallbacks
 *
 * @ExclusionPolicy("all")
 */
class CompanyReport
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"list"})
     */
    private $companyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"list"})
     */
    private $roundId;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $title;

    /**
     * @var integer
     *
     * @ORM\Column(name="code_id", type="integer")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $codeId;

    /**
     * @var string
     *
     * @ORM\Column(name="data_url", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"list"})
     */
    private $dataUrl = '';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="create_at", type="datetime")
     *
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $createAt;

    /**
     * @var bool
     *
     * @ORM\Column(name="extended", type="boolean")
     * @Expose
     * @AnnotationGroups({"teacherReportsList", "list"})
     */
    private $extended = false;

    /**
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="roundReports")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    protected $company;

    /**
     * @ORM\ManyToOne(targetEntity="Round", inversedBy="roundReports")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     */
    protected $round;

    /**
     * @ORM\OneToOne(targetEntity="GroupRoundReportCode")
     * @ORM\JoinColumn(name="code_id", referencedColumnName="id")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    protected $productCode;

    /**
     * @var integer
     *
     * @ORM\Column(name="version", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"list"})
     */
    private $version = 1;


    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return CompanyReport
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return CompanyReport
     */
    public function setTitle($title)
    {
        $this->title = $title;
    
        return $this;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set dataUrl
     *
     * @param string $dataUrl
     * @return CompanyReport
     */
    public function setDataUrl($dataUrl)
    {
        $this->dataUrl = $dataUrl;
    
        return $this;
    }

    /**
     * Get dataUrl
     *
     * @return string 
     */
    public function getDataUrl()
    {
        return $this->dataUrl;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return CompanyReport
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return CompanyReport
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return CompanyReport
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set version
     *
     * @param integer $version
     * @return CompanyReport
     */
    public function setVersion($version)
    {
        $this->version = $version;

        return $this;
    }

    /**
     * Get version
     *
     * @return integer
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return CompanyReport
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set extended
     *
     * @param boolean $extended
     * @return CompanyReport
     */
    public function setExtended($extended)
    {
        $this->extended = $extended;
    
        return $this;
    }

    /**
     * Get extended
     *
     * @return boolean 
     */
    public function getExtended()
    {
        return $this->extended;
    }

    /**
     * Set codeId
     *
     * @param integer $codeId
     * @return CompanyReport
     */
    public function setCodeId($codeId)
    {
        $this->codeId = $codeId;
    
        return $this;
    }

    /**
     * Get codeId
     *
     * @return integer 
     */
    public function getCodeId()
    {
        return $this->codeId;
    }


    /**
     * Set productCode
     *
     * @param \VM\ApiBundle\Entity\GroupRoundReportCode $productCode
     * @return CompanyReport
     */
    public function setProductCode(\VM\ApiBundle\Entity\GroupRoundReportCode $productCode = null)
    {
        $this->productCode = $productCode;
    
        return $this;
    }

    /**
     * Get productCode
     *
     * @return \VM\ApiBundle\Entity\GroupRoundReportCode 
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
}